/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.registry;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import org.betterx.bclib.api.v2.LifeCycleAPI;
import org.betterx.bclib.api.v2.generator.BiomePicker;
import org.betterx.bclib.api.v2.generator.map.hex.HexBiomeMap;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.config.Configs;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.cave.EmptyAuroraCaveBiome;
import org.betterx.betterend.world.biome.cave.EmptyEndCaveBiome;
import org.betterx.betterend.world.biome.cave.EmptySmaragdantCaveBiome;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;
import org.betterx.betterend.world.biome.cave.JadeCaveBiome;
import org.betterx.betterend.world.biome.cave.LushAuroraCaveBiome;
import org.betterx.betterend.world.biome.cave.LushSmaragdantCaveBiome;
import org.betterx.betterend.world.generator.GeneratorOptions;

public class EndBiomes {
    public static final BiomeAPI.BiomeType END_CAVE = new BiomeAPI.BiomeType("END_CAVE", BiomeAPI.BiomeType.END_IGNORE);
    public static BiomePicker CAVE_BIOMES = null;
    private static HexBiomeMap caveBiomeMap;
    private static long lastSeed;
    public static final ResourceKey<Biome> AMBER_LAND;
    public static final ResourceKey<Biome> BLOSSOMING_SPIRES;
    public static final ResourceKey<Biome> CHORUS_FOREST;
    public static final ResourceKey<Biome> FOGGY_MUSHROOMLAND;
    public static final ResourceKey<Biome> GLOWING_GRASSLANDS;
    public static final ResourceKey<Biome> LANTERN_WOODS;
    public static final ResourceKey<Biome> MEGALAKE;
    public static final ResourceKey<Biome> MEGALAKE_GROVE;
    public static final ResourceKey<Biome> NEON_OASIS;
    public static final ResourceKey<Biome> SHADOW_FOREST;
    public static final ResourceKey<Biome> SULPHUR_SPRINGS;
    public static final ResourceKey<Biome> UMBRELLA_JUNGLE;

    private static ResourceKey<Biome> cKey(String path) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)BetterEnd.makeID(path));
    }

    public static void register() {
        BCLBiomeRegistry.registerBiomeCodec((ResourceLocation)BetterEnd.makeID("biome"), EndBiome.KEY_CODEC);
        BCLBiomeRegistry.registerBiomeCodec((ResourceLocation)BetterEnd.makeID("cave_biome"), EndCaveBiome.KEY_CODEC);
        BCLBiomeRegistry.registerBiomeCodec((ResourceLocation)BetterEnd.makeID("empty_aurora_cave_biome"), EmptyAuroraCaveBiome.KEY_CODEC);
        BCLBiomeRegistry.registerBiomeCodec((ResourceLocation)BetterEnd.makeID("empty_end_cave_biome"), EmptyEndCaveBiome.KEY_CODEC);
        BCLBiomeRegistry.registerBiomeCodec((ResourceLocation)BetterEnd.makeID("empty_smaragdant_cave_biome"), EmptySmaragdantCaveBiome.KEY_CODEC);
        BCLBiomeRegistry.registerBiomeCodec((ResourceLocation)BetterEnd.makeID("jade_cave_biome"), JadeCaveBiome.KEY_CODEC);
        BCLBiomeRegistry.registerBiomeCodec((ResourceLocation)BetterEnd.makeID("lush_aurora_cave_biome"), LushAuroraCaveBiome.KEY_CODEC);
        BCLBiomeRegistry.registerBiomeCodec((ResourceLocation)BetterEnd.makeID("lush_smaragdant_cave_biome"), LushSmaragdantCaveBiome.KEY_CODEC);
        LifeCycleAPI.onLevelLoad(EndBiomes::onWorldLoad);
    }

    private static void onWorldLoad(ServerLevel level, long seed, Registry<Biome> registry) {
        if (CAVE_BIOMES == null || EndBiomes.CAVE_BIOMES.biomeRegistry != registry) {
            CAVE_BIOMES = new BiomePicker(registry);
            registry.m_123024_().filter(biome -> registry.m_7854_(biome).isPresent()).map(biome -> registry.m_246971_((ResourceKey)registry.m_7854_(biome).get())).map(biome -> ((ResourceKey)biome.m_203543_().orElseThrow()).m_135782_()).filter(id -> BiomeAPI.wasRegisteredAs((ResourceLocation)id, (BiomeAPI.BiomeType)END_CAVE)).map(BiomeAPI::getBiome).filter(bcl -> !BCLBiomeRegistry.isEmptyBiome((BCLBiome)bcl)).forEach(arg_0 -> ((BiomePicker)CAVE_BIOMES).addBiome(arg_0));
            CAVE_BIOMES.rebuild();
            caveBiomeMap = null;
        }
        if (caveBiomeMap == null || lastSeed != seed) {
            caveBiomeMap = new HexBiomeMap(seed, GeneratorOptions.getBiomeSizeCaves(), CAVE_BIOMES);
            lastSeed = seed;
        }
    }

    public static EndBiome registerSubBiomeIntegration(EndBiome.Config biomeConfig) {
        return EndBiome.create(biomeConfig, BiomeAPI.BiomeType.END_LAND);
    }

    public static void addSubBiomeIntegration(EndBiome biome, ResourceLocation parent) {
        BCLBiome parentBiome;
        if (Configs.BIOME_CONFIG.getBoolean(biome.getID(), "enabled", true) && !BCLBiomeRegistry.isEmptyBiome((BCLBiome)(parentBiome = BiomeAPI.getBiome((ResourceLocation)parent))) && biome.getParentBiome().getID().equals((Object)biome.getID())) {
            parentBiome.addSubBiome((BCLBiome)biome);
        }
    }

    public static BiomePicker.ActualBiome getCaveBiome(int x, int z) {
        return caveBiomeMap.getBiome((double)x, 5.0, (double)z);
    }

    static {
        AMBER_LAND = EndBiomes.cKey("amber_land");
        BLOSSOMING_SPIRES = EndBiomes.cKey("blossoming_spires");
        CHORUS_FOREST = EndBiomes.cKey("chorus_forest");
        FOGGY_MUSHROOMLAND = EndBiomes.cKey("foggy_mushroomland");
        GLOWING_GRASSLANDS = EndBiomes.cKey("glowing_grasslands");
        LANTERN_WOODS = EndBiomes.cKey("lantern_woods");
        MEGALAKE = EndBiomes.cKey("megalake");
        MEGALAKE_GROVE = EndBiomes.cKey("megalake_grove");
        NEON_OASIS = EndBiomes.cKey("neon_oasis");
        SHADOW_FOREST = EndBiomes.cKey("shadow_forest");
        SULPHUR_SPRINGS = EndBiomes.cKey("sulphur_springs");
        UMBRELLA_JUNGLE = EndBiomes.cKey("umbrella_jungle");
    }
}

